/* freakschat
 * Copyright (C) 2009 Berke Viktor
 * 
 * based on X-Chat
 * Copyright (C) 2008 xchat.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


/* XCHAT 2.0 PLUGIN: Mail checker */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifndef WIN32
#include <unistd.h>
#endif

#include "freakschat-plugin.h"


static xchat_plugin *ph;	/* plugin handle */

static int
mail_items(char *file)
{
	FILE *fp;
	int items;
	char buf[512];

	fp = fopen(file, "r");
	if(!fp)
		return 1;

	items = 0;
	while(fgets(buf, sizeof buf, fp))
	{
		if(!strncmp(buf, "From ", 5))
			items++;
	}
	fclose(fp);

	return items;
}

static void
xchat_mail_check (void)
{
	static int last_size = -1;
	int size;
	struct stat st;
	char buf[512];
	char *maildir;

	maildir = getenv("MAIL");
	if(!maildir)
	{
		snprintf (buf, sizeof(buf), "/var/spool/mail/%s", getenv("USER"));
		maildir = buf;
	}

	if(stat(maildir, &st) < 0)
		return;

	size = st.st_size;

	if(last_size == -1)
	{
		last_size = size;
		return;
	}

	if(size > last_size)
	{
		xchat_printf(ph,
	"-\0033-\0039-\017\tYou have new mail (%d messages, %d bytes total).",
				mail_items(maildir), size);
	}

	last_size = size;
}

static int timeout_cb(void *userdata)
{
	xchat_mail_check();

	return 1;
}

int xchat_plugin_init(xchat_plugin *plugin_handle,
				char **plugin_name, char **plugin_desc, char **plugin_version,
				char *arg)
{
	ph = plugin_handle;

	*plugin_name = "MailCheck";
	*plugin_desc = "Checks your mailbox every 30 seconds";
	*plugin_version = "0.1";

	xchat_hook_timer(ph, 30000, timeout_cb, 0);

	return 1;
}
