# -*- buffer-read-only: t -*-
#
# This file is auto-generated. ***ANY*** changes here will be lost
#

package Errno;
require Exporter;
use Config;
use strict;

"$Config{'archname'}-$Config{'osvers'}" eq
"MSWin32-x86-multi-thread-6.2" or
	die "Errno architecture (MSWin32-x86-multi-thread-6.2) does not match executable architecture ($Config{'archname'}-$Config{'osvers'})";

our $VERSION = "1.18";
$VERSION = eval $VERSION;
our @ISA = 'Exporter';

my %err;

BEGIN {
    %err = (
	EPERM => 1,
	ENOENT => 2,
	ESRCH => 3,
	EINTR => 4,
	EIO => 5,
	ENXIO => 6,
	E2BIG => 7,
	ENOEXEC => 8,
	EBADF => 9,
	ECHILD => 10,
	EAGAIN => 11,
	ENOMEM => 12,
	EACCES => 13,
	EFAULT => 14,
	EBUSY => 16,
	EEXIST => 17,
	EXDEV => 18,
	ENODEV => 19,
	ENOTDIR => 20,
	EISDIR => 21,
	EINVAL => 22,
	ENFILE => 23,
	EMFILE => 24,
	ENOTTY => 25,
	EFBIG => 27,
	ENOSPC => 28,
	ESPIPE => 29,
	EROFS => 30,
	EMLINK => 31,
	EPIPE => 32,
	EDOM => 33,
	ERANGE => 34,
	EDEADLOCK => 36,
	EDEADLK => 36,
	ENAMETOOLONG => 38,
	ENOLCK => 39,
	ENOSYS => 40,
	ENOTEMPTY => 41,
	EILSEQ => 42,
	EBADMSG => 104,
	ECANCELED => 105,
	EIDRM => 111,
	ENODATA => 120,
	ENOLINK => 121,
	ENOMSG => 122,
	ENOSR => 124,
	ENOSTR => 125,
	ENOTRECOVERABLE => 127,
	ENOTSUP => 129,
	EOTHER => 131,
	EOVERFLOW => 132,
	EOWNERDEAD => 133,
	EPROTO => 134,
	ETIME => 137,
	ETXTBSY => 139,
	EWOULDBLOCK => 10035,
	EINPROGRESS => 10036,
	EALREADY => 10037,
	ENOTSOCK => 10038,
	EDESTADDRREQ => 10039,
	EMSGSIZE => 10040,
	EPROTOTYPE => 10041,
	ENOPROTOOPT => 10042,
	EPROTONOSUPPORT => 10043,
	ESOCKTNOSUPPORT => 10044,
	EOPNOTSUPP => 10045,
	EPFNOSUPPORT => 10046,
	EAFNOSUPPORT => 10047,
	EADDRINUSE => 10048,
	EADDRNOTAVAIL => 10049,
	ENETDOWN => 10050,
	ENETUNREACH => 10051,
	ENETRESET => 10052,
	ECONNABORTED => 10053,
	ECONNRESET => 10054,
	ENOBUFS => 10055,
	EISCONN => 10056,
	ENOTCONN => 10057,
	ESHUTDOWN => 10058,
	ETOOMANYREFS => 10059,
	ETIMEDOUT => 10060,
	ECONNREFUSED => 10061,
	ELOOP => 10062,
	EHOSTDOWN => 10064,
	EHOSTUNREACH => 10065,
	EPROCLIM => 10067,
	EUSERS => 10068,
	EDQUOT => 10069,
	ESTALE => 10070,
	EREMOTE => 10071,
	EDISCON => 10101,
    );
    # Generate proxy constant subroutines for all the values.
    # Well, almost all the values. Unfortunately we can't assume that at this
    # point that our symbol table is empty, as code such as if the parser has
    # seen code such as C<exists &Errno::EINVAL>, it will have created the
    # typeglob.
    # Doing this before defining @EXPORT_OK etc means that even if a platform is
    # crazy enough to define EXPORT_OK as an error constant, everything will
    # still work, because the parser will upgrade the PCS to a real typeglob.
    # We rely on the subroutine definitions below to update the internal caches.
    # Don't use %each, as we don't want a copy of the value.
    foreach my $name (keys %err) {
        if ($Errno::{$name}) {
            # We expect this to be reached fairly rarely, so take an approach
            # which uses the least compile time effort in the common case:
            eval "sub $name() { $err{$name} }; 1" or die $@;
        } else {
            $Errno::{$name} = \$err{$name};
        }
    }
}

our @EXPORT_OK = keys %err;

our %EXPORT_TAGS = (
    POSIX => [qw(
	E2BIG EACCES EADDRINUSE EADDRNOTAVAIL EAFNOSUPPORT EAGAIN EALREADY
	EBADF EBUSY ECHILD ECONNABORTED ECONNREFUSED ECONNRESET EDEADLK
	EDESTADDRREQ EDOM EDQUOT EEXIST EFAULT EFBIG EHOSTDOWN EHOSTUNREACH
	EINPROGRESS EINTR EINVAL EIO EISCONN EISDIR ELOOP EMFILE EMLINK
	EMSGSIZE ENAMETOOLONG ENETDOWN ENETRESET ENETUNREACH ENFILE ENOBUFS
	ENODEV ENOENT ENOEXEC ENOLCK ENOMEM ENOPROTOOPT ENOSPC ENOSYS ENOTCONN
	ENOTDIR ENOTEMPTY ENOTSOCK ENOTTY ENXIO EOPNOTSUPP EPERM EPFNOSUPPORT
	EPIPE EPROCLIM EPROTONOSUPPORT EPROTOTYPE ERANGE EREMOTE EROFS
	ESHUTDOWN ESOCKTNOSUPPORT ESPIPE ESRCH ESTALE ETIMEDOUT ETOOMANYREFS
	ETXTBSY EUSERS EWOULDBLOCK EXDEV
    )]
);

sub TIEHASH { bless \%err }

sub FETCH {
    my (undef, $errname) = @_;
    return "" unless exists $err{$errname};
    my $errno = $err{$errname};
    return $errno == $! ? $errno : 0;
}

sub STORE {
    require Carp;
    Carp::confess("ERRNO hash is read only!");
}

*CLEAR = *DELETE = \*STORE; # Typeglob aliasing uses less space

sub NEXTKEY {
    each %err;
}

sub FIRSTKEY {
    my $s = scalar keys %err;	# initialize iterator
    each %err;
}

sub EXISTS {
    my (undef, $errname) = @_;
    exists $err{$errname};
}

tie %!, __PACKAGE__; # Returns an object, objects are true.

__END__

=head1 NAME

Errno - System errno constants

=head1 SYNOPSIS

    use Errno qw(EINTR EIO :POSIX);

=head1 DESCRIPTION

C<Errno> defines and conditionally exports all the error constants
defined in your system C<errno.h> include file. It has a single export
tag, C<:POSIX>, which will export all POSIX defined error numbers.

C<Errno> also makes C<%!> magic such that each element of C<%!> has a
non-zero value only if C<$!> is set to that value. For example:

    use Errno;

    unless (open(FH, "/fangorn/spouse")) {
        if ($!{ENOENT}) {
            warn "Get a wife!\n";
        } else {
            warn "This path is barred: $!";
        } 
    } 

If a specified constant C<EFOO> does not exist on the system, C<$!{EFOO}>
returns C<"">.  You may use C<exists $!{EFOO}> to check whether the
constant is available on the system.

=head1 CAVEATS

Importing a particular constant may not be very portable, because the
import will fail on platforms that do not have that constant.  A more
portable way to set C<$!> to a valid value is to use:

    if (exists &Errno::EFOO) {
        $! = &Errno::EFOO;
    }

=head1 AUTHOR

Graham Barr <gbarr@pobox.com>

=head1 COPYRIGHT

Copyright (c) 1997-8 Graham Barr. All rights reserved.
This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

# ex: set ro:
